/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsEmptyCollectionTest
extends AbstractMatcherTest {
    protected Matcher<Collection<?>> createMatcher() {
        return IsEmptyCollection.empty();
    }

    public void testMatchesAnEmptyCollection() {
        IsEmptyCollectionTest.assertMatches("empty collection", this.createMatcher(), IsEmptyCollectionTest.emptyCollection());
    }

    public void testDoesNotMatchACollectionWithAnItem() {
        IsEmptyCollectionTest.assertMismatchDescription("<[one, three]>", Is.is(this.createMatcher()), IsEmptyCollectionTest.collectionOfValues());
    }

    public void testHasAReadableDescription() {
        IsEmptyCollectionTest.assertDescription("an empty collection", this.createMatcher());
    }

    public void testCompiles() {
        this.needs((Matcher<Collection<String>>)IsEmptyCollection.emptyCollectionOf(String.class));
    }

    private void needs(Matcher<Collection<String>> bar) {
    }

    private static Collection<String> collectionOfValues() {
        return new ArrayList<String>(Arrays.asList("one", "three"));
    }

    private static Collection<Integer> emptyCollection() {
        return new ArrayList<Integer>();
    }
}

